import { Loader2 } from "lucide-react";

export default function Loading() {
    return (
        <div className="min-h-screen bg-slate-950 flex flex-col items-center justify-center relative overflow-hidden">
            {/* Background glow */}
            <div className="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-96 h-96 bg-blue-500/10 rounded-full blur-[100px]" />

            <div className="relative z-10 flex flex-col items-center gap-4">
                <div className="relative">
                    <div className="absolute inset-0 rounded-full bg-blue-500/20 blur-md animate-pulse" />
                    <Loader2 className="w-12 h-12 text-blue-400 animate-spin relative z-10" />
                </div>
                <p className="text-slate-400 text-sm tracking-wider animate-pulse uppercase">Loading Project...</p>
            </div>
        </div>
    );
}
